// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// The [vmtx (Vertical Metrics)](https://docs.microsoft.com/en-us/typography/opentype/spec/vmtx) table
#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct VmtxMarker {
    v_metrics_byte_len: usize,
    top_side_bearings_byte_len: usize,
}

impl VmtxMarker {
    pub fn v_metrics_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + self.v_metrics_byte_len
    }

    pub fn top_side_bearings_byte_range(&self) -> Range<usize> {
        let start = self.v_metrics_byte_range().end;
        start..start + self.top_side_bearings_byte_len
    }
}

impl MinByteRange for VmtxMarker {
    fn min_byte_range(&self) -> Range<usize> {
        0..self.top_side_bearings_byte_range().end
    }
}

impl TopLevelTable for Vmtx<'_> {
    /// `vmtx`
    const TAG: Tag = Tag::new(b"vmtx");
}

impl ReadArgs for Vmtx<'_> {
    type Args = u16;
}

impl<'a> FontReadWithArgs<'a> for Vmtx<'a> {
    fn read_with_args(data: FontData<'a>, args: &u16) -> Result<Self, ReadError> {
        let number_of_long_ver_metrics = *args;
        let mut cursor = data.cursor();
        let v_metrics_byte_len = (number_of_long_ver_metrics as usize)
            .checked_mul(LongMetric::RAW_BYTE_LEN)
            .ok_or(ReadError::OutOfBounds)?;
        cursor.advance_by(v_metrics_byte_len);
        let top_side_bearings_byte_len =
            cursor.remaining_bytes() / i16::RAW_BYTE_LEN * i16::RAW_BYTE_LEN;
        cursor.advance_by(top_side_bearings_byte_len);
        cursor.finish(VmtxMarker {
            v_metrics_byte_len,
            top_side_bearings_byte_len,
        })
    }
}

impl<'a> Vmtx<'a> {
    /// A constructor that requires additional arguments.
    ///
    /// This type requires some external state in order to be
    /// parsed.
    pub fn read(data: FontData<'a>, number_of_long_ver_metrics: u16) -> Result<Self, ReadError> {
        let args = number_of_long_ver_metrics;
        Self::read_with_args(data, &args)
    }
}

/// The [vmtx (Vertical Metrics)](https://docs.microsoft.com/en-us/typography/opentype/spec/vmtx) table
pub type Vmtx<'a> = TableRef<'a, VmtxMarker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> Vmtx<'a> {
    /// Paired advance height and top side bearing values for each
    /// glyph. Records are indexed by glyph ID.
    pub fn v_metrics(&self) -> &'a [LongMetric] {
        let range = self.shape.v_metrics_byte_range();
        self.data.read_array(range).unwrap()
    }

    /// Top side bearings for glyph IDs greater than or equal to numberOfLongMetrics.
    pub fn top_side_bearings(&self) -> &'a [BigEndian<i16>] {
        let range = self.shape.top_side_bearings_byte_range();
        self.data.read_array(range).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for Vmtx<'a> {
    fn type_name(&self) -> &str {
        "Vmtx"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new(
                "v_metrics",
                traversal::FieldType::array_of_records(
                    stringify!(LongMetric),
                    self.v_metrics(),
                    self.offset_data(),
                ),
            )),
            1usize => Some(Field::new("top_side_bearings", self.top_side_bearings())),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for Vmtx<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}
