;;; lsp-d.el --- lsp-mode dlang integration -*- lexical-binding: t; -*-

;; Copyright (C) 2021 lsp-mode maintainers

;; Author: lsp-mode maintainers
;; Keywords: languages

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

;;; Commentary:

;;  client for serve-d

;;; Code:

(require 'lsp-mode)
(require 'ht)

(lsp-register-client
 (make-lsp-client :new-connection (lsp-stdio-connection "serve-d")
                  :major-modes '(d-mode)
                  :notification-handlers
                  (ht ("coded/changedSelectedWorkspace" #'ignore)
                      ("coded/initDubTree" #'ignore))
                  :server-id 'serve-d))

(lsp-consistency-check lsp-d)

(provide 'lsp-d)
;;; lsp-d.el ends here
