// Code generated by loong64spec LoongArch-Vol1-EN.pdf, DO NOT EDIT.

// Copyright 2024 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package loong64asm

const (
	_ Op = iota
	ADDI_D
	ADDI_W
	ADDU16I_D
	ADD_D
	ADD_W
	ALSL_D
	ALSL_W
	ALSL_WU
	AMADD_B
	AMADD_D
	AMADD_DB_B
	AMADD_DB_D
	AMADD_DB_H
	AMADD_DB_W
	AMADD_H
	AMADD_W
	AMAND_D
	AMAND_DB_D
	AMAND_DB_W
	AMAND_W
	AMCAS_B
	AMCAS_D
	AMCAS_DB_B
	AMCAS_DB_D
	AMCAS_DB_H
	AMCAS_DB_W
	AMCAS_H
	AMCAS_W
	AMMAX_D
	AMMAX_DB_D
	AMMAX_DB_DU
	AMMAX_DB_W
	AMMAX_DB_WU
	AMMAX_DU
	AMMAX_W
	AMMAX_WU
	AMMIN_D
	AMMIN_DB_D
	AMMIN_DB_DU
	AMMIN_DB_W
	AMMIN_DB_WU
	AMMIN_DU
	AMMIN_W
	AMMIN_WU
	AMOR_D
	AMOR_DB_D
	AMOR_DB_W
	AMOR_W
	AMSWAP_B
	AMSWAP_D
	AMSWAP_DB_B
	AMSWAP_DB_D
	AMSWAP_DB_H
	AMSWAP_DB_W
	AMSWAP_H
	AMSWAP_W
	AMXOR_D
	AMXOR_DB_D
	AMXOR_DB_W
	AMXOR_W
	AND
	ANDI
	ANDN
	ASRTGT_D
	ASRTLE_D
	B
	BCEQZ
	BCNEZ
	BEQ
	BEQZ
	BGE
	BGEU
	BITREV_4B
	BITREV_8B
	BITREV_D
	BITREV_W
	BL
	BLT
	BLTU
	BNE
	BNEZ
	BREAK
	BSTRINS_D
	BSTRINS_W
	BSTRPICK_D
	BSTRPICK_W
	BYTEPICK_D
	BYTEPICK_W
	CACOP
	CLO_D
	CLO_W
	CLZ_D
	CLZ_W
	CPUCFG
	CRCC_W_B_W
	CRCC_W_D_W
	CRCC_W_H_W
	CRCC_W_W_W
	CRC_W_B_W
	CRC_W_D_W
	CRC_W_H_W
	CRC_W_W_W
	CSRRD
	CSRWR
	CSRXCHG
	CTO_D
	CTO_W
	CTZ_D
	CTZ_W
	DBAR
	DBCL
	DIV_D
	DIV_DU
	DIV_W
	DIV_WU
	ERTN
	EXT_W_B
	EXT_W_H
	FABS_D
	FABS_S
	FADD_D
	FADD_S
	FCLASS_D
	FCLASS_S
	FCMP_CAF_D
	FCMP_CAF_S
	FCMP_CEQ_D
	FCMP_CEQ_S
	FCMP_CLE_D
	FCMP_CLE_S
	FCMP_CLT_D
	FCMP_CLT_S
	FCMP_CNE_D
	FCMP_CNE_S
	FCMP_COR_D
	FCMP_COR_S
	FCMP_CUEQ_D
	FCMP_CUEQ_S
	FCMP_CULE_D
	FCMP_CULE_S
	FCMP_CULT_D
	FCMP_CULT_S
	FCMP_CUNE_D
	FCMP_CUNE_S
	FCMP_CUN_D
	FCMP_CUN_S
	FCMP_SAF_D
	FCMP_SAF_S
	FCMP_SEQ_D
	FCMP_SEQ_S
	FCMP_SLE_D
	FCMP_SLE_S
	FCMP_SLT_D
	FCMP_SLT_S
	FCMP_SNE_D
	FCMP_SNE_S
	FCMP_SOR_D
	FCMP_SOR_S
	FCMP_SUEQ_D
	FCMP_SUEQ_S
	FCMP_SULE_D
	FCMP_SULE_S
	FCMP_SULT_D
	FCMP_SULT_S
	FCMP_SUNE_D
	FCMP_SUNE_S
	FCMP_SUN_D
	FCMP_SUN_S
	FCOPYSIGN_D
	FCOPYSIGN_S
	FCVT_D_S
	FCVT_S_D
	FDIV_D
	FDIV_S
	FFINT_D_L
	FFINT_D_W
	FFINT_S_L
	FFINT_S_W
	FLDGT_D
	FLDGT_S
	FLDLE_D
	FLDLE_S
	FLDX_D
	FLDX_S
	FLD_D
	FLD_S
	FLOGB_D
	FLOGB_S
	FMADD_D
	FMADD_S
	FMAXA_D
	FMAXA_S
	FMAX_D
	FMAX_S
	FMINA_D
	FMINA_S
	FMIN_D
	FMIN_S
	FMOV_D
	FMOV_S
	FMSUB_D
	FMSUB_S
	FMUL_D
	FMUL_S
	FNEG_D
	FNEG_S
	FNMADD_D
	FNMADD_S
	FNMSUB_D
	FNMSUB_S
	FRECIPE_D
	FRECIPE_S
	FRECIP_D
	FRECIP_S
	FRINT_D
	FRINT_S
	FRSQRTE_D
	FRSQRTE_S
	FRSQRT_D
	FRSQRT_S
	FSCALEB_D
	FSCALEB_S
	FSEL
	FSQRT_D
	FSQRT_S
	FSTGT_D
	FSTGT_S
	FSTLE_D
	FSTLE_S
	FSTX_D
	FSTX_S
	FST_D
	FST_S
	FSUB_D
	FSUB_S
	FTINTRM_L_D
	FTINTRM_L_S
	FTINTRM_W_D
	FTINTRM_W_S
	FTINTRNE_L_D
	FTINTRNE_L_S
	FTINTRNE_W_D
	FTINTRNE_W_S
	FTINTRP_L_D
	FTINTRP_L_S
	FTINTRP_W_D
	FTINTRP_W_S
	FTINTRZ_L_D
	FTINTRZ_L_S
	FTINTRZ_W_D
	FTINTRZ_W_S
	FTINT_L_D
	FTINT_L_S
	FTINT_W_D
	FTINT_W_S
	IBAR
	IDLE
	INVTLB
	IOCSRRD_B
	IOCSRRD_D
	IOCSRRD_H
	IOCSRRD_W
	IOCSRWR_B
	IOCSRWR_D
	IOCSRWR_H
	IOCSRWR_W
	JIRL
	LDDIR
	LDGT_B
	LDGT_D
	LDGT_H
	LDGT_W
	LDLE_B
	LDLE_D
	LDLE_H
	LDLE_W
	LDPTE
	LDPTR_D
	LDPTR_W
	LDX_B
	LDX_BU
	LDX_D
	LDX_H
	LDX_HU
	LDX_W
	LDX_WU
	LD_B
	LD_BU
	LD_D
	LD_H
	LD_HU
	LD_W
	LD_WU
	LLACQ_D
	LLACQ_W
	LL_D
	LL_W
	LU12I_W
	LU32I_D
	LU52I_D
	MASKEQZ
	MASKNEZ
	MOD_D
	MOD_DU
	MOD_W
	MOD_WU
	MOVCF2FR
	MOVCF2GR
	MOVFCSR2GR
	MOVFR2CF
	MOVFR2GR_D
	MOVFR2GR_S
	MOVFRH2GR_S
	MOVGR2CF
	MOVGR2FCSR
	MOVGR2FRH_W
	MOVGR2FR_D
	MOVGR2FR_W
	MULH_D
	MULH_DU
	MULH_W
	MULH_WU
	MULW_D_W
	MULW_D_WU
	MUL_D
	MUL_W
	NOR
	OR
	ORI
	ORN
	PCADDI
	PCADDU12I
	PCADDU18I
	PCALAU12I
	PRELD
	PRELDX
	RDTIMEH_W
	RDTIMEL_W
	RDTIME_D
	REVB_2H
	REVB_2W
	REVB_4H
	REVB_D
	REVH_2W
	REVH_D
	ROTRI_D
	ROTRI_W
	ROTR_D
	ROTR_W
	SCREL_D
	SCREL_W
	SC_D
	SC_Q
	SC_W
	SLLI_D
	SLLI_W
	SLL_D
	SLL_W
	SLT
	SLTI
	SLTU
	SLTUI
	SRAI_D
	SRAI_W
	SRA_D
	SRA_W
	SRLI_D
	SRLI_W
	SRL_D
	SRL_W
	STGT_B
	STGT_D
	STGT_H
	STGT_W
	STLE_B
	STLE_D
	STLE_H
	STLE_W
	STPTR_D
	STPTR_W
	STX_B
	STX_D
	STX_H
	STX_W
	ST_B
	ST_D
	ST_H
	ST_W
	SUB_D
	SUB_W
	SYSCALL
	TLBCLR
	TLBFILL
	TLBFLUSH
	TLBRD
	TLBSRCH
	TLBWR
	XOR
	XORI
)

var opstr = [...]string{
	ADDI_D:       "ADDI.D",
	ADDI_W:       "ADDI.W",
	ADDU16I_D:    "ADDU16I.D",
	ADD_D:        "ADD.D",
	ADD_W:        "ADD.W",
	ALSL_D:       "ALSL.D",
	ALSL_W:       "ALSL.W",
	ALSL_WU:      "ALSL.WU",
	AMADD_B:      "AMADD.B",
	AMADD_D:      "AMADD.D",
	AMADD_DB_B:   "AMADD_DB.B",
	AMADD_DB_D:   "AMADD_DB.D",
	AMADD_DB_H:   "AMADD_DB.H",
	AMADD_DB_W:   "AMADD_DB.W",
	AMADD_H:      "AMADD.H",
	AMADD_W:      "AMADD.W",
	AMAND_D:      "AMAND.D",
	AMAND_DB_D:   "AMAND_DB.D",
	AMAND_DB_W:   "AMAND_DB.W",
	AMAND_W:      "AMAND.W",
	AMCAS_B:      "AMCAS.B",
	AMCAS_D:      "AMCAS.D",
	AMCAS_DB_B:   "AMCAS_DB.B",
	AMCAS_DB_D:   "AMCAS_DB.D",
	AMCAS_DB_H:   "AMCAS_DB.H",
	AMCAS_DB_W:   "AMCAS_DB.W",
	AMCAS_H:      "AMCAS.H",
	AMCAS_W:      "AMCAS.W",
	AMMAX_D:      "AMMAX.D",
	AMMAX_DB_D:   "AMMAX_DB.D",
	AMMAX_DB_DU:  "AMMAX_DB.DU",
	AMMAX_DB_W:   "AMMAX_DB.W",
	AMMAX_DB_WU:  "AMMAX_DB.WU",
	AMMAX_DU:     "AMMAX.DU",
	AMMAX_W:      "AMMAX.W",
	AMMAX_WU:     "AMMAX.WU",
	AMMIN_D:      "AMMIN.D",
	AMMIN_DB_D:   "AMMIN_DB.D",
	AMMIN_DB_DU:  "AMMIN_DB.DU",
	AMMIN_DB_W:   "AMMIN_DB.W",
	AMMIN_DB_WU:  "AMMIN_DB.WU",
	AMMIN_DU:     "AMMIN.DU",
	AMMIN_W:      "AMMIN.W",
	AMMIN_WU:     "AMMIN.WU",
	AMOR_D:       "AMOR.D",
	AMOR_DB_D:    "AMOR_DB.D",
	AMOR_DB_W:    "AMOR_DB.W",
	AMOR_W:       "AMOR.W",
	AMSWAP_B:     "AMSWAP.B",
	AMSWAP_D:     "AMSWAP.D",
	AMSWAP_DB_B:  "AMSWAP_DB.B",
	AMSWAP_DB_D:  "AMSWAP_DB.D",
	AMSWAP_DB_H:  "AMSWAP_DB.H",
	AMSWAP_DB_W:  "AMSWAP_DB.W",
	AMSWAP_H:     "AMSWAP.H",
	AMSWAP_W:     "AMSWAP.W",
	AMXOR_D:      "AMXOR.D",
	AMXOR_DB_D:   "AMXOR_DB.D",
	AMXOR_DB_W:   "AMXOR_DB.W",
	AMXOR_W:      "AMXOR.W",
	AND:          "AND",
	ANDI:         "ANDI",
	ANDN:         "ANDN",
	ASRTGT_D:     "ASRTGT.D",
	ASRTLE_D:     "ASRTLE.D",
	B:            "B",
	BCEQZ:        "BCEQZ",
	BCNEZ:        "BCNEZ",
	BEQ:          "BEQ",
	BEQZ:         "BEQZ",
	BGE:          "BGE",
	BGEU:         "BGEU",
	BITREV_4B:    "BITREV.4B",
	BITREV_8B:    "BITREV.8B",
	BITREV_D:     "BITREV.D",
	BITREV_W:     "BITREV.W",
	BL:           "BL",
	BLT:          "BLT",
	BLTU:         "BLTU",
	BNE:          "BNE",
	BNEZ:         "BNEZ",
	BREAK:        "BREAK",
	BSTRINS_D:    "BSTRINS.D",
	BSTRINS_W:    "BSTRINS.W",
	BSTRPICK_D:   "BSTRPICK.D",
	BSTRPICK_W:   "BSTRPICK.W",
	BYTEPICK_D:   "BYTEPICK.D",
	BYTEPICK_W:   "BYTEPICK.W",
	CACOP:        "CACOP",
	CLO_D:        "CLO.D",
	CLO_W:        "CLO.W",
	CLZ_D:        "CLZ.D",
	CLZ_W:        "CLZ.W",
	CPUCFG:       "CPUCFG",
	CRCC_W_B_W:   "CRCC.W.B.W",
	CRCC_W_D_W:   "CRCC.W.D.W",
	CRCC_W_H_W:   "CRCC.W.H.W",
	CRCC_W_W_W:   "CRCC.W.W.W",
	CRC_W_B_W:    "CRC.W.B.W",
	CRC_W_D_W:    "CRC.W.D.W",
	CRC_W_H_W:    "CRC.W.H.W",
	CRC_W_W_W:    "CRC.W.W.W",
	CSRRD:        "CSRRD",
	CSRWR:        "CSRWR",
	CSRXCHG:      "CSRXCHG",
	CTO_D:        "CTO.D",
	CTO_W:        "CTO.W",
	CTZ_D:        "CTZ.D",
	CTZ_W:        "CTZ.W",
	DBAR:         "DBAR",
	DBCL:         "DBCL",
	DIV_D:        "DIV.D",
	DIV_DU:       "DIV.DU",
	DIV_W:        "DIV.W",
	DIV_WU:       "DIV.WU",
	ERTN:         "ERTN",
	EXT_W_B:      "EXT.W.B",
	EXT_W_H:      "EXT.W.H",
	FABS_D:       "FABS.D",
	FABS_S:       "FABS.S",
	FADD_D:       "FADD.D",
	FADD_S:       "FADD.S",
	FCLASS_D:     "FCLASS.D",
	FCLASS_S:     "FCLASS.S",
	FCMP_CAF_D:   "FCMP.CAF.D",
	FCMP_CAF_S:   "FCMP.CAF.S",
	FCMP_CEQ_D:   "FCMP.CEQ.D",
	FCMP_CEQ_S:   "FCMP.CEQ.S",
	FCMP_CLE_D:   "FCMP.CLE.D",
	FCMP_CLE_S:   "FCMP.CLE.S",
	FCMP_CLT_D:   "FCMP.CLT.D",
	FCMP_CLT_S:   "FCMP.CLT.S",
	FCMP_CNE_D:   "FCMP.CNE.D",
	FCMP_CNE_S:   "FCMP.CNE.S",
	FCMP_COR_D:   "FCMP.COR.D",
	FCMP_COR_S:   "FCMP.COR.S",
	FCMP_CUEQ_D:  "FCMP.CUEQ.D",
	FCMP_CUEQ_S:  "FCMP.CUEQ.S",
	FCMP_CULE_D:  "FCMP.CULE.D",
	FCMP_CULE_S:  "FCMP.CULE.S",
	FCMP_CULT_D:  "FCMP.CULT.D",
	FCMP_CULT_S:  "FCMP.CULT.S",
	FCMP_CUNE_D:  "FCMP.CUNE.D",
	FCMP_CUNE_S:  "FCMP.CUNE.S",
	FCMP_CUN_D:   "FCMP.CUN.D",
	FCMP_CUN_S:   "FCMP.CUN.S",
	FCMP_SAF_D:   "FCMP.SAF.D",
	FCMP_SAF_S:   "FCMP.SAF.S",
	FCMP_SEQ_D:   "FCMP.SEQ.D",
	FCMP_SEQ_S:   "FCMP.SEQ.S",
	FCMP_SLE_D:   "FCMP.SLE.D",
	FCMP_SLE_S:   "FCMP.SLE.S",
	FCMP_SLT_D:   "FCMP.SLT.D",
	FCMP_SLT_S:   "FCMP.SLT.S",
	FCMP_SNE_D:   "FCMP.SNE.D",
	FCMP_SNE_S:   "FCMP.SNE.S",
	FCMP_SOR_D:   "FCMP.SOR.D",
	FCMP_SOR_S:   "FCMP.SOR.S",
	FCMP_SUEQ_D:  "FCMP.SUEQ.D",
	FCMP_SUEQ_S:  "FCMP.SUEQ.S",
	FCMP_SULE_D:  "FCMP.SULE.D",
	FCMP_SULE_S:  "FCMP.SULE.S",
	FCMP_SULT_D:  "FCMP.SULT.D",
	FCMP_SULT_S:  "FCMP.SULT.S",
	FCMP_SUNE_D:  "FCMP.SUNE.D",
	FCMP_SUNE_S:  "FCMP.SUNE.S",
	FCMP_SUN_D:   "FCMP.SUN.D",
	FCMP_SUN_S:   "FCMP.SUN.S",
	FCOPYSIGN_D:  "FCOPYSIGN.D",
	FCOPYSIGN_S:  "FCOPYSIGN.S",
	FCVT_D_S:     "FCVT.D.S",
	FCVT_S_D:     "FCVT.S.D",
	FDIV_D:       "FDIV.D",
	FDIV_S:       "FDIV.S",
	FFINT_D_L:    "FFINT.D.L",
	FFINT_D_W:    "FFINT.D.W",
	FFINT_S_L:    "FFINT.S.L",
	FFINT_S_W:    "FFINT.S.W",
	FLDGT_D:      "FLDGT.D",
	FLDGT_S:      "FLDGT.S",
	FLDLE_D:      "FLDLE.D",
	FLDLE_S:      "FLDLE.S",
	FLDX_D:       "FLDX.D",
	FLDX_S:       "FLDX.S",
	FLD_D:        "FLD.D",
	FLD_S:        "FLD.S",
	FLOGB_D:      "FLOGB.D",
	FLOGB_S:      "FLOGB.S",
	FMADD_D:      "FMADD.D",
	FMADD_S:      "FMADD.S",
	FMAXA_D:      "FMAXA.D",
	FMAXA_S:      "FMAXA.S",
	FMAX_D:       "FMAX.D",
	FMAX_S:       "FMAX.S",
	FMINA_D:      "FMINA.D",
	FMINA_S:      "FMINA.S",
	FMIN_D:       "FMIN.D",
	FMIN_S:       "FMIN.S",
	FMOV_D:       "FMOV.D",
	FMOV_S:       "FMOV.S",
	FMSUB_D:      "FMSUB.D",
	FMSUB_S:      "FMSUB.S",
	FMUL_D:       "FMUL.D",
	FMUL_S:       "FMUL.S",
	FNEG_D:       "FNEG.D",
	FNEG_S:       "FNEG.S",
	FNMADD_D:     "FNMADD.D",
	FNMADD_S:     "FNMADD.S",
	FNMSUB_D:     "FNMSUB.D",
	FNMSUB_S:     "FNMSUB.S",
	FRECIPE_D:    "FRECIPE.D",
	FRECIPE_S:    "FRECIPE.S",
	FRECIP_D:     "FRECIP.D",
	FRECIP_S:     "FRECIP.S",
	FRINT_D:      "FRINT.D",
	FRINT_S:      "FRINT.S",
	FRSQRTE_D:    "FRSQRTE.D",
	FRSQRTE_S:    "FRSQRTE.S",
	FRSQRT_D:     "FRSQRT.D",
	FRSQRT_S:     "FRSQRT.S",
	FSCALEB_D:    "FSCALEB.D",
	FSCALEB_S:    "FSCALEB.S",
	FSEL:         "FSEL",
	FSQRT_D:      "FSQRT.D",
	FSQRT_S:      "FSQRT.S",
	FSTGT_D:      "FSTGT.D",
	FSTGT_S:      "FSTGT.S",
	FSTLE_D:      "FSTLE.D",
	FSTLE_S:      "FSTLE.S",
	FSTX_D:       "FSTX.D",
	FSTX_S:       "FSTX.S",
	FST_D:        "FST.D",
	FST_S:        "FST.S",
	FSUB_D:       "FSUB.D",
	FSUB_S:       "FSUB.S",
	FTINTRM_L_D:  "FTINTRM.L.D",
	FTINTRM_L_S:  "FTINTRM.L.S",
	FTINTRM_W_D:  "FTINTRM.W.D",
	FTINTRM_W_S:  "FTINTRM.W.S",
	FTINTRNE_L_D: "FTINTRNE.L.D",
	FTINTRNE_L_S: "FTINTRNE.L.S",
	FTINTRNE_W_D: "FTINTRNE.W.D",
	FTINTRNE_W_S: "FTINTRNE.W.S",
	FTINTRP_L_D:  "FTINTRP.L.D",
	FTINTRP_L_S:  "FTINTRP.L.S",
	FTINTRP_W_D:  "FTINTRP.W.D",
	FTINTRP_W_S:  "FTINTRP.W.S",
	FTINTRZ_L_D:  "FTINTRZ.L.D",
	FTINTRZ_L_S:  "FTINTRZ.L.S",
	FTINTRZ_W_D:  "FTINTRZ.W.D",
	FTINTRZ_W_S:  "FTINTRZ.W.S",
	FTINT_L_D:    "FTINT.L.D",
	FTINT_L_S:    "FTINT.L.S",
	FTINT_W_D:    "FTINT.W.D",
	FTINT_W_S:    "FTINT.W.S",
	IBAR:         "IBAR",
	IDLE:         "IDLE",
	INVTLB:       "INVTLB",
	IOCSRRD_B:    "IOCSRRD.B",
	IOCSRRD_D:    "IOCSRRD.D",
	IOCSRRD_H:    "IOCSRRD.H",
	IOCSRRD_W:    "IOCSRRD.W",
	IOCSRWR_B:    "IOCSRWR.B",
	IOCSRWR_D:    "IOCSRWR.D",
	IOCSRWR_H:    "IOCSRWR.H",
	IOCSRWR_W:    "IOCSRWR.W",
	JIRL:         "JIRL",
	LDDIR:        "LDDIR",
	LDGT_B:       "LDGT.B",
	LDGT_D:       "LDGT.D",
	LDGT_H:       "LDGT.H",
	LDGT_W:       "LDGT.W",
	LDLE_B:       "LDLE.B",
	LDLE_D:       "LDLE.D",
	LDLE_H:       "LDLE.H",
	LDLE_W:       "LDLE.W",
	LDPTE:        "LDPTE",
	LDPTR_D:      "LDPTR.D",
	LDPTR_W:      "LDPTR.W",
	LDX_B:        "LDX.B",
	LDX_BU:       "LDX.BU",
	LDX_D:        "LDX.D",
	LDX_H:        "LDX.H",
	LDX_HU:       "LDX.HU",
	LDX_W:        "LDX.W",
	LDX_WU:       "LDX.WU",
	LD_B:         "LD.B",
	LD_BU:        "LD.BU",
	LD_D:         "LD.D",
	LD_H:         "LD.H",
	LD_HU:        "LD.HU",
	LD_W:         "LD.W",
	LD_WU:        "LD.WU",
	LLACQ_D:      "LLACQ.D",
	LLACQ_W:      "LLACQ.W",
	LL_D:         "LL.D",
	LL_W:         "LL.W",
	LU12I_W:      "LU12I.W",
	LU32I_D:      "LU32I.D",
	LU52I_D:      "LU52I.D",
	MASKEQZ:      "MASKEQZ",
	MASKNEZ:      "MASKNEZ",
	MOD_D:        "MOD.D",
	MOD_DU:       "MOD.DU",
	MOD_W:        "MOD.W",
	MOD_WU:       "MOD.WU",
	MOVCF2FR:     "MOVCF2FR",
	MOVCF2GR:     "MOVCF2GR",
	MOVFCSR2GR:   "MOVFCSR2GR",
	MOVFR2CF:     "MOVFR2CF",
	MOVFR2GR_D:   "MOVFR2GR.D",
	MOVFR2GR_S:   "MOVFR2GR.S",
	MOVFRH2GR_S:  "MOVFRH2GR.S",
	MOVGR2CF:     "MOVGR2CF",
	MOVGR2FCSR:   "MOVGR2FCSR",
	MOVGR2FRH_W:  "MOVGR2FRH.W",
	MOVGR2FR_D:   "MOVGR2FR.D",
	MOVGR2FR_W:   "MOVGR2FR.W",
	MULH_D:       "MULH.D",
	MULH_DU:      "MULH.DU",
	MULH_W:       "MULH.W",
	MULH_WU:      "MULH.WU",
	MULW_D_W:     "MULW.D.W",
	MULW_D_WU:    "MULW.D.WU",
	MUL_D:        "MUL.D",
	MUL_W:        "MUL.W",
	NOR:          "NOR",
	OR:           "OR",
	ORI:          "ORI",
	ORN:          "ORN",
	PCADDI:       "PCADDI",
	PCADDU12I:    "PCADDU12I",
	PCADDU18I:    "PCADDU18I",
	PCALAU12I:    "PCALAU12I",
	PRELD:        "PRELD",
	PRELDX:       "PRELDX",
	RDTIMEH_W:    "RDTIMEH.W",
	RDTIMEL_W:    "RDTIMEL.W",
	RDTIME_D:     "RDTIME.D",
	REVB_2H:      "REVB.2H",
	REVB_2W:      "REVB.2W",
	REVB_4H:      "REVB.4H",
	REVB_D:       "REVB.D",
	REVH_2W:      "REVH.2W",
	REVH_D:       "REVH.D",
	ROTRI_D:      "ROTRI.D",
	ROTRI_W:      "ROTRI.W",
	ROTR_D:       "ROTR.D",
	ROTR_W:       "ROTR.W",
	SCREL_D:      "SCREL.D",
	SCREL_W:      "SCREL.W",
	SC_D:         "SC.D",
	SC_Q:         "SC.Q",
	SC_W:         "SC.W",
	SLLI_D:       "SLLI.D",
	SLLI_W:       "SLLI.W",
	SLL_D:        "SLL.D",
	SLL_W:        "SLL.W",
	SLT:          "SLT",
	SLTI:         "SLTI",
	SLTU:         "SLTU",
	SLTUI:        "SLTUI",
	SRAI_D:       "SRAI.D",
	SRAI_W:       "SRAI.W",
	SRA_D:        "SRA.D",
	SRA_W:        "SRA.W",
	SRLI_D:       "SRLI.D",
	SRLI_W:       "SRLI.W",
	SRL_D:        "SRL.D",
	SRL_W:        "SRL.W",
	STGT_B:       "STGT.B",
	STGT_D:       "STGT.D",
	STGT_H:       "STGT.H",
	STGT_W:       "STGT.W",
	STLE_B:       "STLE.B",
	STLE_D:       "STLE.D",
	STLE_H:       "STLE.H",
	STLE_W:       "STLE.W",
	STPTR_D:      "STPTR.D",
	STPTR_W:      "STPTR.W",
	STX_B:        "STX.B",
	STX_D:        "STX.D",
	STX_H:        "STX.H",
	STX_W:        "STX.W",
	ST_B:         "ST.B",
	ST_D:         "ST.D",
	ST_H:         "ST.H",
	ST_W:         "ST.W",
	SUB_D:        "SUB.D",
	SUB_W:        "SUB.W",
	SYSCALL:      "SYSCALL",
	TLBCLR:       "TLBCLR",
	TLBFILL:      "TLBFILL",
	TLBFLUSH:     "TLBFLUSH",
	TLBRD:        "TLBRD",
	TLBSRCH:      "TLBSRCH",
	TLBWR:        "TLBWR",
	XOR:          "XOR",
	XORI:         "XORI",
}

var instFormats = [...]instFormat{
	// ADDI.D rd, rj, si12
	{mask: 0xffc00000, value: 0x02c00000, op: ADDI_D, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// ADDI.W rd, rj, si12
	{mask: 0xffc00000, value: 0x02800000, op: ADDI_W, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// ADDU16I.D rd, rj, si16
	{mask: 0xfc000000, value: 0x10000000, op: ADDU16I_D, args: instArgs{arg_rd, arg_rj, arg_si16_25_10}},
	// ADD.D rd, rj, rk
	{mask: 0xffff8000, value: 0x00108000, op: ADD_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// ADD.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00100000, op: ADD_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// ALSL.D rd, rj, rk, sa2
	{mask: 0xfffe0000, value: 0x002c0000, op: ALSL_D, args: instArgs{arg_rd, arg_rj, arg_rk, arg_sa2_16_15}},
	// ALSL.W rd, rj, rk, sa2
	{mask: 0xfffe0000, value: 0x00040000, op: ALSL_W, args: instArgs{arg_rd, arg_rj, arg_rk, arg_sa2_16_15}},
	// ALSL.WU rd, rj, rk, sa2
	{mask: 0xfffe0000, value: 0x00060000, op: ALSL_WU, args: instArgs{arg_rd, arg_rj, arg_rk, arg_sa2_16_15}},
	// AMADD.B rd, rk, rj
	{mask: 0xffff8000, value: 0x385d0000, op: AMADD_B, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMADD.D rd, rk, rj
	{mask: 0xffff8000, value: 0x38618000, op: AMADD_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMADD_DB.B rd, rk, rj
	{mask: 0xffff8000, value: 0x385f0000, op: AMADD_DB_B, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMADD_DB.D rd, rk, rj
	{mask: 0xffff8000, value: 0x386a8000, op: AMADD_DB_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMADD_DB.H rd, rk, rj
	{mask: 0xffff8000, value: 0x385f8000, op: AMADD_DB_H, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMADD_DB.W rd, rk, rj
	{mask: 0xffff8000, value: 0x386a0000, op: AMADD_DB_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMADD.H rd, rk, rj
	{mask: 0xffff8000, value: 0x385d8000, op: AMADD_H, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMADD.W rd, rk, rj
	{mask: 0xffff8000, value: 0x38610000, op: AMADD_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMAND.D rd, rk, rj
	{mask: 0xffff8000, value: 0x38628000, op: AMAND_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMAND_DB.D rd, rk, rj
	{mask: 0xffff8000, value: 0x386b8000, op: AMAND_DB_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMAND_DB.W rd, rk, rj
	{mask: 0xffff8000, value: 0x386b0000, op: AMAND_DB_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMAND.W rd, rk, rj
	{mask: 0xffff8000, value: 0x38620000, op: AMAND_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMCAS.B rd, rk, rj
	{mask: 0xffff8000, value: 0x38580000, op: AMCAS_B, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMCAS.D rd, rk, rj
	{mask: 0xffff8000, value: 0x38598000, op: AMCAS_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMCAS_DB.B rd, rk, rj
	{mask: 0xffff8000, value: 0x385a0000, op: AMCAS_DB_B, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMCAS_DB.D rd, rk, rj
	{mask: 0xffff8000, value: 0x385b8000, op: AMCAS_DB_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMCAS_DB.H rd, rk, rj
	{mask: 0xffff8000, value: 0x385a8000, op: AMCAS_DB_H, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMCAS_DB.W rd, rk, rj
	{mask: 0xffff8000, value: 0x385b0000, op: AMCAS_DB_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMCAS.H rd, rk, rj
	{mask: 0xffff8000, value: 0x38588000, op: AMCAS_H, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMCAS.W rd, rk, rj
	{mask: 0xffff8000, value: 0x38590000, op: AMCAS_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMAX.D rd, rk, rj
	{mask: 0xffff8000, value: 0x38658000, op: AMMAX_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMAX_DB.D rd, rk, rj
	{mask: 0xffff8000, value: 0x386e8000, op: AMMAX_DB_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMAX_DB.DU rd, rk, rj
	{mask: 0xffff8000, value: 0x38708000, op: AMMAX_DB_DU, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMAX_DB.W rd, rk, rj
	{mask: 0xffff8000, value: 0x386e0000, op: AMMAX_DB_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMAX_DB.WU rd, rk, rj
	{mask: 0xffff8000, value: 0x38700000, op: AMMAX_DB_WU, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMAX.DU rd, rk, rj
	{mask: 0xffff8000, value: 0x38678000, op: AMMAX_DU, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMAX.W rd, rk, rj
	{mask: 0xffff8000, value: 0x38650000, op: AMMAX_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMAX.WU rd, rk, rj
	{mask: 0xffff8000, value: 0x38670000, op: AMMAX_WU, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMIN.D rd, rk, rj
	{mask: 0xffff8000, value: 0x38668000, op: AMMIN_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMIN_DB.D rd, rk, rj
	{mask: 0xffff8000, value: 0x386f8000, op: AMMIN_DB_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMIN_DB.DU rd, rk, rj
	{mask: 0xffff8000, value: 0x38718000, op: AMMIN_DB_DU, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMIN_DB.W rd, rk, rj
	{mask: 0xffff8000, value: 0x386f0000, op: AMMIN_DB_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMIN_DB.WU rd, rk, rj
	{mask: 0xffff8000, value: 0x38710000, op: AMMIN_DB_WU, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMIN.DU rd, rk, rj
	{mask: 0xffff8000, value: 0x38688000, op: AMMIN_DU, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMIN.W rd, rk, rj
	{mask: 0xffff8000, value: 0x38660000, op: AMMIN_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMMIN.WU rd, rk, rj
	{mask: 0xffff8000, value: 0x38680000, op: AMMIN_WU, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMOR.D rd, rk, rj
	{mask: 0xffff8000, value: 0x38638000, op: AMOR_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMOR_DB.D rd, rk, rj
	{mask: 0xffff8000, value: 0x386c8000, op: AMOR_DB_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMOR_DB.W rd, rk, rj
	{mask: 0xffff8000, value: 0x386c0000, op: AMOR_DB_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMOR.W rd, rk, rj
	{mask: 0xffff8000, value: 0x38630000, op: AMOR_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMSWAP.B rd, rk, rj
	{mask: 0xffff8000, value: 0x385c0000, op: AMSWAP_B, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMSWAP.D rd, rk, rj
	{mask: 0xffff8000, value: 0x38608000, op: AMSWAP_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMSWAP_DB.B rd, rk, rj
	{mask: 0xffff8000, value: 0x385e0000, op: AMSWAP_DB_B, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMSWAP_DB.D rd, rk, rj
	{mask: 0xffff8000, value: 0x38698000, op: AMSWAP_DB_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMSWAP_DB.H rd, rk, rj
	{mask: 0xffff8000, value: 0x385e8000, op: AMSWAP_DB_H, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMSWAP_DB.W rd, rk, rj
	{mask: 0xffff8000, value: 0x38690000, op: AMSWAP_DB_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMSWAP.H rd, rk, rj
	{mask: 0xffff8000, value: 0x385c8000, op: AMSWAP_H, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMSWAP.W rd, rk, rj
	{mask: 0xffff8000, value: 0x38600000, op: AMSWAP_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMXOR.D rd, rk, rj
	{mask: 0xffff8000, value: 0x38648000, op: AMXOR_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMXOR_DB.D rd, rk, rj
	{mask: 0xffff8000, value: 0x386d8000, op: AMXOR_DB_D, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMXOR_DB.W rd, rk, rj
	{mask: 0xffff8000, value: 0x386d0000, op: AMXOR_DB_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AMXOR.W rd, rk, rj
	{mask: 0xffff8000, value: 0x38640000, op: AMXOR_W, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// AND rd, rj, rk
	{mask: 0xffff8000, value: 0x00148000, op: AND, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// ANDI rd, rj, ui12
	{mask: 0xffc00000, value: 0x03400000, op: ANDI, args: instArgs{arg_rd, arg_rj, arg_ui12_21_10}},
	// ANDN rd, rj, rk
	{mask: 0xffff8000, value: 0x00168000, op: ANDN, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// ASRTGT.D rj, rk
	{mask: 0xffff801f, value: 0x00018000, op: ASRTGT_D, args: instArgs{arg_rj, arg_rk}},
	// ASRTLE.D rj, rk
	{mask: 0xffff801f, value: 0x00010000, op: ASRTLE_D, args: instArgs{arg_rj, arg_rk}},
	// B offs
	{mask: 0xfc000000, value: 0x50000000, op: B, args: instArgs{arg_offset_25_0}},
	// BCEQZ cj, offs
	{mask: 0xfc000300, value: 0x48000000, op: BCEQZ, args: instArgs{arg_cj, arg_offset_20_0}},
	// BCNEZ cj, offs
	{mask: 0xfc000300, value: 0x48000100, op: BCNEZ, args: instArgs{arg_cj, arg_offset_20_0}},
	// BEQ rj, rd, offs
	{mask: 0xfc000000, value: 0x58000000, op: BEQ, args: instArgs{arg_rj, arg_rd, arg_offset_15_0}},
	// BEQZ rj, offs
	{mask: 0xfc000000, value: 0x40000000, op: BEQZ, args: instArgs{arg_rj, arg_offset_20_0}},
	// BGE rj, rd, offs
	{mask: 0xfc000000, value: 0x64000000, op: BGE, args: instArgs{arg_rj, arg_rd, arg_offset_15_0}},
	// BGEU rj, rd, offs
	{mask: 0xfc000000, value: 0x6c000000, op: BGEU, args: instArgs{arg_rj, arg_rd, arg_offset_15_0}},
	// BITREV.4B rd, rj
	{mask: 0xfffffc00, value: 0x00004800, op: BITREV_4B, args: instArgs{arg_rd, arg_rj}},
	// BITREV.8B rd, rj
	{mask: 0xfffffc00, value: 0x00004c00, op: BITREV_8B, args: instArgs{arg_rd, arg_rj}},
	// BITREV.D rd, rj
	{mask: 0xfffffc00, value: 0x00005400, op: BITREV_D, args: instArgs{arg_rd, arg_rj}},
	// BITREV.W rd, rj
	{mask: 0xfffffc00, value: 0x00005000, op: BITREV_W, args: instArgs{arg_rd, arg_rj}},
	// BL offs
	{mask: 0xfc000000, value: 0x54000000, op: BL, args: instArgs{arg_offset_25_0}},
	// BLT rj, rd, offs
	{mask: 0xfc000000, value: 0x60000000, op: BLT, args: instArgs{arg_rj, arg_rd, arg_offset_15_0}},
	// BLTU rj, rd, offs
	{mask: 0xfc000000, value: 0x68000000, op: BLTU, args: instArgs{arg_rj, arg_rd, arg_offset_15_0}},
	// BNE rj, rd, offs
	{mask: 0xfc000000, value: 0x5c000000, op: BNE, args: instArgs{arg_rj, arg_rd, arg_offset_15_0}},
	// BNEZ rj, offs
	{mask: 0xfc000000, value: 0x44000000, op: BNEZ, args: instArgs{arg_rj, arg_offset_20_0}},
	// BREAK code
	{mask: 0xffff8000, value: 0x002a0000, op: BREAK, args: instArgs{arg_code_14_0}},
	// BSTRINS.D rd, rj, msbd, lsbd
	{mask: 0xffc00000, value: 0x00800000, op: BSTRINS_D, args: instArgs{arg_rd, arg_rj, arg_msbd, arg_lsbd}},
	// BSTRINS.W rd, rj, msbw, lsbw
	{mask: 0xffe08000, value: 0x00600000, op: BSTRINS_W, args: instArgs{arg_rd, arg_rj, arg_msbw, arg_lsbw}},
	// BSTRPICK.D rd, rj, msbd, lsbd
	{mask: 0xffc00000, value: 0x00c00000, op: BSTRPICK_D, args: instArgs{arg_rd, arg_rj, arg_msbd, arg_lsbd}},
	// BSTRPICK.W rd, rj, msbw, lsbw
	{mask: 0xffe08000, value: 0x00608000, op: BSTRPICK_W, args: instArgs{arg_rd, arg_rj, arg_msbw, arg_lsbw}},
	// BYTEPICK.D rd, rj, rk, sa3
	{mask: 0xfffc0000, value: 0x000c0000, op: BYTEPICK_D, args: instArgs{arg_rd, arg_rj, arg_rk, arg_sa3_17_15}},
	// BYTEPICK.W rd, rj, rk, sa2
	{mask: 0xfffe0000, value: 0x00080000, op: BYTEPICK_W, args: instArgs{arg_rd, arg_rj, arg_rk, arg_sa2_16_15}},
	// CACOP code, rj, si12
	{mask: 0xffc00000, value: 0x06000000, op: CACOP, args: instArgs{arg_code_4_0, arg_rj, arg_si12_21_10}},
	// CLO.D rd, rj
	{mask: 0xfffffc00, value: 0x00002000, op: CLO_D, args: instArgs{arg_rd, arg_rj}},
	// CLO.W rd, rj
	{mask: 0xfffffc00, value: 0x00001000, op: CLO_W, args: instArgs{arg_rd, arg_rj}},
	// CLZ.D rd, rj
	{mask: 0xfffffc00, value: 0x00002400, op: CLZ_D, args: instArgs{arg_rd, arg_rj}},
	// CLZ.W rd, rj
	{mask: 0xfffffc00, value: 0x00001400, op: CLZ_W, args: instArgs{arg_rd, arg_rj}},
	// CPUCFG rd, rj
	{mask: 0xfffffc00, value: 0x00006c00, op: CPUCFG, args: instArgs{arg_rd, arg_rj}},
	// CRCC.W.B.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00260000, op: CRCC_W_B_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// CRCC.W.D.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00278000, op: CRCC_W_D_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// CRCC.W.H.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00268000, op: CRCC_W_H_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// CRCC.W.W.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00270000, op: CRCC_W_W_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// CRC.W.B.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00240000, op: CRC_W_B_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// CRC.W.D.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00258000, op: CRC_W_D_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// CRC.W.H.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00248000, op: CRC_W_H_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// CRC.W.W.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00250000, op: CRC_W_W_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// CSRRD rd, csr
	{mask: 0xff0003e0, value: 0x04000000, op: CSRRD, args: instArgs{arg_rd, arg_csr_23_10}},
	// CSRWR rd, csr
	{mask: 0xff0003e0, value: 0x04000020, op: CSRWR, args: instArgs{arg_rd, arg_csr_23_10}},
	// CSRXCHG rd, rj, csr
	{mask: 0xff000000, value: 0x04000000, op: CSRXCHG, args: instArgs{arg_rd, arg_rj, arg_csr_23_10}},
	// CTO.D rd, rj
	{mask: 0xfffffc00, value: 0x00002800, op: CTO_D, args: instArgs{arg_rd, arg_rj}},
	// CTO.W rd, rj
	{mask: 0xfffffc00, value: 0x00001800, op: CTO_W, args: instArgs{arg_rd, arg_rj}},
	// CTZ.D rd, rj
	{mask: 0xfffffc00, value: 0x00002c00, op: CTZ_D, args: instArgs{arg_rd, arg_rj}},
	// CTZ.W rd, rj
	{mask: 0xfffffc00, value: 0x00001c00, op: CTZ_W, args: instArgs{arg_rd, arg_rj}},
	// DBAR hint
	{mask: 0xffff8000, value: 0x38720000, op: DBAR, args: instArgs{arg_hint_14_0}},
	// DBCL code
	{mask: 0xffff8000, value: 0x002a8000, op: DBCL, args: instArgs{arg_code_14_0}},
	// DIV.D rd, rj, rk
	{mask: 0xffff8000, value: 0x00220000, op: DIV_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// DIV.DU rd, rj, rk
	{mask: 0xffff8000, value: 0x00230000, op: DIV_DU, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// DIV.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00200000, op: DIV_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// DIV.WU rd, rj, rk
	{mask: 0xffff8000, value: 0x00210000, op: DIV_WU, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// ERTN
	{mask: 0xffffffff, value: 0x06483800, op: ERTN, args: instArgs{}},
	// EXT.W.B rd, rj
	{mask: 0xfffffc00, value: 0x00005c00, op: EXT_W_B, args: instArgs{arg_rd, arg_rj}},
	// EXT.W.H rd, rj
	{mask: 0xfffffc00, value: 0x00005800, op: EXT_W_H, args: instArgs{arg_rd, arg_rj}},
	// FABS.D fd, fj
	{mask: 0xfffffc00, value: 0x01140800, op: FABS_D, args: instArgs{arg_fd, arg_fj}},
	// FABS.S fd, fj
	{mask: 0xfffffc00, value: 0x01140400, op: FABS_S, args: instArgs{arg_fd, arg_fj}},
	// FADD.D fd, fj, fk
	{mask: 0xffff8000, value: 0x01010000, op: FADD_D, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FADD.S fd, fj, fk
	{mask: 0xffff8000, value: 0x01008000, op: FADD_S, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FCLASS.D fd, fj
	{mask: 0xfffffc00, value: 0x01143800, op: FCLASS_D, args: instArgs{arg_fd, arg_fj}},
	// FCLASS.S fd, fj
	{mask: 0xfffffc00, value: 0x01143400, op: FCLASS_S, args: instArgs{arg_fd, arg_fj}},
	// FCMP.CAF.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c200000, op: FCMP_CAF_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CAF.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c100000, op: FCMP_CAF_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CEQ.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c220000, op: FCMP_CEQ_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CEQ.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c120000, op: FCMP_CEQ_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CLE.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c230000, op: FCMP_CLE_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CLE.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c130000, op: FCMP_CLE_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CLT.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c210000, op: FCMP_CLT_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CLT.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c110000, op: FCMP_CLT_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CNE.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c280000, op: FCMP_CNE_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CNE.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c180000, op: FCMP_CNE_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.COR.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c2a0000, op: FCMP_COR_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.COR.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c1a0000, op: FCMP_COR_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CUEQ.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c260000, op: FCMP_CUEQ_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CUEQ.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c160000, op: FCMP_CUEQ_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CULE.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c270000, op: FCMP_CULE_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CULE.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c170000, op: FCMP_CULE_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CULT.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c250000, op: FCMP_CULT_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CULT.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c150000, op: FCMP_CULT_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CUNE.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c2c0000, op: FCMP_CUNE_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CUNE.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c1c0000, op: FCMP_CUNE_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CUN.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c240000, op: FCMP_CUN_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.CUN.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c140000, op: FCMP_CUN_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SAF.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c208000, op: FCMP_SAF_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SAF.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c108000, op: FCMP_SAF_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SEQ.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c228000, op: FCMP_SEQ_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SEQ.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c128000, op: FCMP_SEQ_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SLE.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c238000, op: FCMP_SLE_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SLE.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c138000, op: FCMP_SLE_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SLT.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c218000, op: FCMP_SLT_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SLT.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c118000, op: FCMP_SLT_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SNE.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c288000, op: FCMP_SNE_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SNE.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c188000, op: FCMP_SNE_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SOR.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c2a8000, op: FCMP_SOR_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SOR.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c1a8000, op: FCMP_SOR_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SUEQ.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c268000, op: FCMP_SUEQ_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SUEQ.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c168000, op: FCMP_SUEQ_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SULE.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c278000, op: FCMP_SULE_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SULE.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c178000, op: FCMP_SULE_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SULT.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c258000, op: FCMP_SULT_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SULT.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c158000, op: FCMP_SULT_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SUNE.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c2c8000, op: FCMP_SUNE_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SUNE.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c1c8000, op: FCMP_SUNE_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SUN.D cd, fj, fk
	{mask: 0xffff8018, value: 0x0c248000, op: FCMP_SUN_D, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCMP.SUN.S cd, fj, fk
	{mask: 0xffff8018, value: 0x0c148000, op: FCMP_SUN_S, args: instArgs{arg_cd, arg_fj, arg_fk}},
	// FCOPYSIGN.D fd, fj, fk
	{mask: 0xffff8000, value: 0x01130000, op: FCOPYSIGN_D, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FCOPYSIGN.S fd, fj, fk
	{mask: 0xffff8000, value: 0x01128000, op: FCOPYSIGN_S, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FCVT.D.S fd, fj
	{mask: 0xfffffc00, value: 0x01192400, op: FCVT_D_S, args: instArgs{arg_fd, arg_fj}},
	// FCVT.S.D fd, fj
	{mask: 0xfffffc00, value: 0x01191800, op: FCVT_S_D, args: instArgs{arg_fd, arg_fj}},
	// FDIV.D fd, fj, fk
	{mask: 0xffff8000, value: 0x01070000, op: FDIV_D, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FDIV.S fd, fj, fk
	{mask: 0xffff8000, value: 0x01068000, op: FDIV_S, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FFINT.D.L fd, fj
	{mask: 0xfffffc00, value: 0x011d2800, op: FFINT_D_L, args: instArgs{arg_fd, arg_fj}},
	// FFINT.D.W fd, fj
	{mask: 0xfffffc00, value: 0x011d2000, op: FFINT_D_W, args: instArgs{arg_fd, arg_fj}},
	// FFINT.S.L fd, fj
	{mask: 0xfffffc00, value: 0x011d1800, op: FFINT_S_L, args: instArgs{arg_fd, arg_fj}},
	// FFINT.S.W fd, fj
	{mask: 0xfffffc00, value: 0x011d1000, op: FFINT_S_W, args: instArgs{arg_fd, arg_fj}},
	// FLDGT.D fd, rj, rk
	{mask: 0xffff8000, value: 0x38748000, op: FLDGT_D, args: instArgs{arg_fd, arg_rj, arg_rk}},
	// FLDGT.S fd, rj, rk
	{mask: 0xffff8000, value: 0x38740000, op: FLDGT_S, args: instArgs{arg_fd, arg_rj, arg_rk}},
	// FLDLE.D fd, rj, rk
	{mask: 0xffff8000, value: 0x38758000, op: FLDLE_D, args: instArgs{arg_fd, arg_rj, arg_rk}},
	// FLDLE.S fd, rj, rk
	{mask: 0xffff8000, value: 0x38750000, op: FLDLE_S, args: instArgs{arg_fd, arg_rj, arg_rk}},
	// FLDX.D fd, rj, rk
	{mask: 0xffff8000, value: 0x38340000, op: FLDX_D, args: instArgs{arg_fd, arg_rj, arg_rk}},
	// FLDX.S fd, rj, rk
	{mask: 0xffff8000, value: 0x38300000, op: FLDX_S, args: instArgs{arg_fd, arg_rj, arg_rk}},
	// FLD.D fd, rj, si12
	{mask: 0xffc00000, value: 0x2b800000, op: FLD_D, args: instArgs{arg_fd, arg_rj, arg_si12_21_10}},
	// FLD.S fd, rj, si12
	{mask: 0xffc00000, value: 0x2b000000, op: FLD_S, args: instArgs{arg_fd, arg_rj, arg_si12_21_10}},
	// FLOGB.D fd, fj
	{mask: 0xfffffc00, value: 0x01142800, op: FLOGB_D, args: instArgs{arg_fd, arg_fj}},
	// FLOGB.S fd, fj
	{mask: 0xfffffc00, value: 0x01142400, op: FLOGB_S, args: instArgs{arg_fd, arg_fj}},
	// FMADD.D fd, fj, fk, fa
	{mask: 0xfff00000, value: 0x08200000, op: FMADD_D, args: instArgs{arg_fd, arg_fj, arg_fk, arg_fa}},
	// FMADD.S fd, fj, fk, fa
	{mask: 0xfff00000, value: 0x08100000, op: FMADD_S, args: instArgs{arg_fd, arg_fj, arg_fk, arg_fa}},
	// FMAXA.D fd, fj, fk
	{mask: 0xffff8000, value: 0x010d0000, op: FMAXA_D, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FMAXA.S fd, fj, fk
	{mask: 0xffff8000, value: 0x010c8000, op: FMAXA_S, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FMAX.D fd, fj, fk
	{mask: 0xffff8000, value: 0x01090000, op: FMAX_D, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FMAX.S fd, fj, fk
	{mask: 0xffff8000, value: 0x01088000, op: FMAX_S, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FMINA.D fd, fj, fk
	{mask: 0xffff8000, value: 0x010f0000, op: FMINA_D, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FMINA.S fd, fj, fk
	{mask: 0xffff8000, value: 0x010e8000, op: FMINA_S, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FMIN.D fd, fj, fk
	{mask: 0xffff8000, value: 0x010b0000, op: FMIN_D, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FMIN.S fd, fj, fk
	{mask: 0xffff8000, value: 0x010a8000, op: FMIN_S, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FMOV.D fd, fj
	{mask: 0xfffffc00, value: 0x01149800, op: FMOV_D, args: instArgs{arg_fd, arg_fj}},
	// FMOV.S fd, fj
	{mask: 0xfffffc00, value: 0x01149400, op: FMOV_S, args: instArgs{arg_fd, arg_fj}},
	// FMSUB.D fd, fj, fk, fa
	{mask: 0xfff00000, value: 0x08600000, op: FMSUB_D, args: instArgs{arg_fd, arg_fj, arg_fk, arg_fa}},
	// FMSUB.S fd, fj, fk, fa
	{mask: 0xfff00000, value: 0x08500000, op: FMSUB_S, args: instArgs{arg_fd, arg_fj, arg_fk, arg_fa}},
	// FMUL.D fd, fj, fk
	{mask: 0xffff8000, value: 0x01050000, op: FMUL_D, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FMUL.S fd, fj, fk
	{mask: 0xffff8000, value: 0x01048000, op: FMUL_S, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FNEG.D fd, fj
	{mask: 0xfffffc00, value: 0x01141800, op: FNEG_D, args: instArgs{arg_fd, arg_fj}},
	// FNEG.S fd, fj
	{mask: 0xfffffc00, value: 0x01141400, op: FNEG_S, args: instArgs{arg_fd, arg_fj}},
	// FNMADD.D fd, fj, fk, fa
	{mask: 0xfff00000, value: 0x08a00000, op: FNMADD_D, args: instArgs{arg_fd, arg_fj, arg_fk, arg_fa}},
	// FNMADD.S fd, fj, fk, fa
	{mask: 0xfff00000, value: 0x08900000, op: FNMADD_S, args: instArgs{arg_fd, arg_fj, arg_fk, arg_fa}},
	// FNMSUB.D fd, fj, fk, fa
	{mask: 0xfff00000, value: 0x08e00000, op: FNMSUB_D, args: instArgs{arg_fd, arg_fj, arg_fk, arg_fa}},
	// FNMSUB.S fd, fj, fk, fa
	{mask: 0xfff00000, value: 0x08d00000, op: FNMSUB_S, args: instArgs{arg_fd, arg_fj, arg_fk, arg_fa}},
	// FRECIPE.D fd, fj
	{mask: 0xfffffc00, value: 0x01147800, op: FRECIPE_D, args: instArgs{arg_fd, arg_fj}},
	// FRECIPE.S fd, fj
	{mask: 0xfffffc00, value: 0x01147400, op: FRECIPE_S, args: instArgs{arg_fd, arg_fj}},
	// FRECIP.D fd, fj
	{mask: 0xfffffc00, value: 0x01145800, op: FRECIP_D, args: instArgs{arg_fd, arg_fj}},
	// FRECIP.S fd, fj
	{mask: 0xfffffc00, value: 0x01145400, op: FRECIP_S, args: instArgs{arg_fd, arg_fj}},
	// FRINT.D fd, fj
	{mask: 0xfffffc00, value: 0x011e4800, op: FRINT_D, args: instArgs{arg_fd, arg_fj}},
	// FRINT.S fd, fj
	{mask: 0xfffffc00, value: 0x011e4400, op: FRINT_S, args: instArgs{arg_fd, arg_fj}},
	// FRSQRTE.D fd, fj
	{mask: 0xfffffc00, value: 0x01148800, op: FRSQRTE_D, args: instArgs{arg_fd, arg_fj}},
	// FRSQRTE.S fd, fj
	{mask: 0xfffffc00, value: 0x01148400, op: FRSQRTE_S, args: instArgs{arg_fd, arg_fj}},
	// FRSQRT.D fd, fj
	{mask: 0xfffffc00, value: 0x01146800, op: FRSQRT_D, args: instArgs{arg_fd, arg_fj}},
	// FRSQRT.S fd, fj
	{mask: 0xfffffc00, value: 0x01146400, op: FRSQRT_S, args: instArgs{arg_fd, arg_fj}},
	// FSCALEB.D fd, fj, fk
	{mask: 0xffff8000, value: 0x01110000, op: FSCALEB_D, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FSCALEB.S fd, fj, fk
	{mask: 0xffff8000, value: 0x01108000, op: FSCALEB_S, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FSEL fd, fj, fk, ca
	{mask: 0xfffc0000, value: 0x0d000000, op: FSEL, args: instArgs{arg_fd, arg_fj, arg_fk, arg_ca}},
	// FSQRT.D fd, fj
	{mask: 0xfffffc00, value: 0x01144800, op: FSQRT_D, args: instArgs{arg_fd, arg_fj}},
	// FSQRT.S fd, fj
	{mask: 0xfffffc00, value: 0x01144400, op: FSQRT_S, args: instArgs{arg_fd, arg_fj}},
	// FSTGT.D fd, rj, rk
	{mask: 0xffff8000, value: 0x38768000, op: FSTGT_D, args: instArgs{arg_fd, arg_rj, arg_rk}},
	// FSTGT.S fd, rj, rk
	{mask: 0xffff8000, value: 0x38760000, op: FSTGT_S, args: instArgs{arg_fd, arg_rj, arg_rk}},
	// FSTLE.D fd, rj, rk
	{mask: 0xffff8000, value: 0x38778000, op: FSTLE_D, args: instArgs{arg_fd, arg_rj, arg_rk}},
	// FSTLE.S fd, rj, rk
	{mask: 0xffff8000, value: 0x38770000, op: FSTLE_S, args: instArgs{arg_fd, arg_rj, arg_rk}},
	// FSTX.D fd, rj, rk
	{mask: 0xffff8000, value: 0x383c0000, op: FSTX_D, args: instArgs{arg_fd, arg_rj, arg_rk}},
	// FSTX.S fd, rj, rk
	{mask: 0xffff8000, value: 0x38380000, op: FSTX_S, args: instArgs{arg_fd, arg_rj, arg_rk}},
	// FST.D fd, rj, si12
	{mask: 0xffc00000, value: 0x2bc00000, op: FST_D, args: instArgs{arg_fd, arg_rj, arg_si12_21_10}},
	// FST.S fd, rj, si12
	{mask: 0xffc00000, value: 0x2b400000, op: FST_S, args: instArgs{arg_fd, arg_rj, arg_si12_21_10}},
	// FSUB.D fd, fj, fk
	{mask: 0xffff8000, value: 0x01030000, op: FSUB_D, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FSUB.S fd, fj, fk
	{mask: 0xffff8000, value: 0x01028000, op: FSUB_S, args: instArgs{arg_fd, arg_fj, arg_fk}},
	// FTINTRM.L.D fd, fj
	{mask: 0xfffffc00, value: 0x011a2800, op: FTINTRM_L_D, args: instArgs{arg_fd, arg_fj}},
	// FTINTRM.L.S fd, fj
	{mask: 0xfffffc00, value: 0x011a2400, op: FTINTRM_L_S, args: instArgs{arg_fd, arg_fj}},
	// FTINTRM.W.D fd, fj
	{mask: 0xfffffc00, value: 0x011a0800, op: FTINTRM_W_D, args: instArgs{arg_fd, arg_fj}},
	// FTINTRM.W.S fd, fj
	{mask: 0xfffffc00, value: 0x011a0400, op: FTINTRM_W_S, args: instArgs{arg_fd, arg_fj}},
	// FTINTRNE.L.D fd, fj
	{mask: 0xfffffc00, value: 0x011ae800, op: FTINTRNE_L_D, args: instArgs{arg_fd, arg_fj}},
	// FTINTRNE.L.S fd, fj
	{mask: 0xfffffc00, value: 0x011ae400, op: FTINTRNE_L_S, args: instArgs{arg_fd, arg_fj}},
	// FTINTRNE.W.D fd, fj
	{mask: 0xfffffc00, value: 0x011ac800, op: FTINTRNE_W_D, args: instArgs{arg_fd, arg_fj}},
	// FTINTRNE.W.S fd, fj
	{mask: 0xfffffc00, value: 0x011ac400, op: FTINTRNE_W_S, args: instArgs{arg_fd, arg_fj}},
	// FTINTRP.L.D fd, fj
	{mask: 0xfffffc00, value: 0x011a6800, op: FTINTRP_L_D, args: instArgs{arg_fd, arg_fj}},
	// FTINTRP.L.S fd, fj
	{mask: 0xfffffc00, value: 0x011a6400, op: FTINTRP_L_S, args: instArgs{arg_fd, arg_fj}},
	// FTINTRP.W.D fd, fj
	{mask: 0xfffffc00, value: 0x011a4800, op: FTINTRP_W_D, args: instArgs{arg_fd, arg_fj}},
	// FTINTRP.W.S fd, fj
	{mask: 0xfffffc00, value: 0x011a4400, op: FTINTRP_W_S, args: instArgs{arg_fd, arg_fj}},
	// FTINTRZ.L.D fd, fj
	{mask: 0xfffffc00, value: 0x011aa800, op: FTINTRZ_L_D, args: instArgs{arg_fd, arg_fj}},
	// FTINTRZ.L.S fd, fj
	{mask: 0xfffffc00, value: 0x011aa400, op: FTINTRZ_L_S, args: instArgs{arg_fd, arg_fj}},
	// FTINTRZ.W.D fd, fj
	{mask: 0xfffffc00, value: 0x011a8800, op: FTINTRZ_W_D, args: instArgs{arg_fd, arg_fj}},
	// FTINTRZ.W.S fd, fj
	{mask: 0xfffffc00, value: 0x011a8400, op: FTINTRZ_W_S, args: instArgs{arg_fd, arg_fj}},
	// FTINT.L.D fd, fj
	{mask: 0xfffffc00, value: 0x011b2800, op: FTINT_L_D, args: instArgs{arg_fd, arg_fj}},
	// FTINT.L.S fd, fj
	{mask: 0xfffffc00, value: 0x011b2400, op: FTINT_L_S, args: instArgs{arg_fd, arg_fj}},
	// FTINT.W.D fd, fj
	{mask: 0xfffffc00, value: 0x011b0800, op: FTINT_W_D, args: instArgs{arg_fd, arg_fj}},
	// FTINT.W.S fd, fj
	{mask: 0xfffffc00, value: 0x011b0400, op: FTINT_W_S, args: instArgs{arg_fd, arg_fj}},
	// IBAR hint
	{mask: 0xffff8000, value: 0x38728000, op: IBAR, args: instArgs{arg_hint_14_0}},
	// IDLE level
	{mask: 0xffff8000, value: 0x06488000, op: IDLE, args: instArgs{arg_level_14_0}},
	// INVTLB op, rj, rk
	{mask: 0xffff8000, value: 0x06498000, op: INVTLB, args: instArgs{arg_op_4_0, arg_rj, arg_rk}},
	// IOCSRRD.B rd, rj
	{mask: 0xfffffc00, value: 0x06480000, op: IOCSRRD_B, args: instArgs{arg_rd, arg_rj}},
	// IOCSRRD.D rd, rj
	{mask: 0xfffffc00, value: 0x06480c00, op: IOCSRRD_D, args: instArgs{arg_rd, arg_rj}},
	// IOCSRRD.H rd, rj
	{mask: 0xfffffc00, value: 0x06480400, op: IOCSRRD_H, args: instArgs{arg_rd, arg_rj}},
	// IOCSRRD.W rd, rj
	{mask: 0xfffffc00, value: 0x06480800, op: IOCSRRD_W, args: instArgs{arg_rd, arg_rj}},
	// IOCSRWR.B rd, rj
	{mask: 0xfffffc00, value: 0x06481000, op: IOCSRWR_B, args: instArgs{arg_rd, arg_rj}},
	// IOCSRWR.D rd, rj
	{mask: 0xfffffc00, value: 0x06481c00, op: IOCSRWR_D, args: instArgs{arg_rd, arg_rj}},
	// IOCSRWR.H rd, rj
	{mask: 0xfffffc00, value: 0x06481400, op: IOCSRWR_H, args: instArgs{arg_rd, arg_rj}},
	// IOCSRWR.W rd, rj
	{mask: 0xfffffc00, value: 0x06481800, op: IOCSRWR_W, args: instArgs{arg_rd, arg_rj}},
	// JIRL rd, rj, offs
	{mask: 0xfc000000, value: 0x4c000000, op: JIRL, args: instArgs{arg_rd, arg_rj, arg_offset_15_0}},
	// LDDIR rd, rj, level
	{mask: 0xfffc0000, value: 0x06400000, op: LDDIR, args: instArgs{arg_rd, arg_rj, arg_level_17_10}},
	// LDGT.B rd, rj, rk
	{mask: 0xffff8000, value: 0x38780000, op: LDGT_B, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDGT.D rd, rj, rk
	{mask: 0xffff8000, value: 0x38798000, op: LDGT_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDGT.H rd, rj, rk
	{mask: 0xffff8000, value: 0x38788000, op: LDGT_H, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDGT.W rd, rj, rk
	{mask: 0xffff8000, value: 0x38790000, op: LDGT_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDLE.B rd, rj, rk
	{mask: 0xffff8000, value: 0x387a0000, op: LDLE_B, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDLE.D rd, rj, rk
	{mask: 0xffff8000, value: 0x387b8000, op: LDLE_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDLE.H rd, rj, rk
	{mask: 0xffff8000, value: 0x387a8000, op: LDLE_H, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDLE.W rd, rj, rk
	{mask: 0xffff8000, value: 0x387b0000, op: LDLE_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDPTE rj, seq
	{mask: 0xfffc001f, value: 0x06440000, op: LDPTE, args: instArgs{arg_rj, arg_seq_17_10}},
	// LDPTR.D rd, rj, si14
	{mask: 0xff000000, value: 0x26000000, op: LDPTR_D, args: instArgs{arg_rd, arg_rj, arg_si14_23_10}},
	// LDPTR.W rd, rj, si14
	{mask: 0xff000000, value: 0x24000000, op: LDPTR_W, args: instArgs{arg_rd, arg_rj, arg_si14_23_10}},
	// LDX.B rd, rj, rk
	{mask: 0xffff8000, value: 0x38000000, op: LDX_B, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDX.BU rd, rj, rk
	{mask: 0xffff8000, value: 0x38200000, op: LDX_BU, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDX.D rd, rj, rk
	{mask: 0xffff8000, value: 0x380c0000, op: LDX_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDX.H rd, rj, rk
	{mask: 0xffff8000, value: 0x38040000, op: LDX_H, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDX.HU rd, rj, rk
	{mask: 0xffff8000, value: 0x38240000, op: LDX_HU, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDX.W rd, rj, rk
	{mask: 0xffff8000, value: 0x38080000, op: LDX_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LDX.WU rd, rj, rk
	{mask: 0xffff8000, value: 0x38280000, op: LDX_WU, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// LD.B rd, rj, si12
	{mask: 0xffc00000, value: 0x28000000, op: LD_B, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// LD.BU rd, rj, si12
	{mask: 0xffc00000, value: 0x2a000000, op: LD_BU, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// LD.D rd, rj, si12
	{mask: 0xffc00000, value: 0x28c00000, op: LD_D, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// LD.H rd, rj, si12
	{mask: 0xffc00000, value: 0x28400000, op: LD_H, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// LD.HU rd, rj, si12
	{mask: 0xffc00000, value: 0x2a400000, op: LD_HU, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// LD.W rd, rj, si12
	{mask: 0xffc00000, value: 0x28800000, op: LD_W, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// LD.WU rd, rj, si12
	{mask: 0xffc00000, value: 0x2a800000, op: LD_WU, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// LLACQ.D rd, rj
	{mask: 0xfffffc00, value: 0x38578800, op: LLACQ_D, args: instArgs{arg_rd, arg_rj}},
	// LLACQ.W rd, rj
	{mask: 0xfffffc00, value: 0x38578000, op: LLACQ_W, args: instArgs{arg_rd, arg_rj}},
	// LL.D rd, rj, si14
	{mask: 0xff000000, value: 0x22000000, op: LL_D, args: instArgs{arg_rd, arg_rj, arg_si14_23_10}},
	// LL.W rd, rj, si14
	{mask: 0xff000000, value: 0x20000000, op: LL_W, args: instArgs{arg_rd, arg_rj, arg_si14_23_10}},
	// LU12I.W rd, si20
	{mask: 0xfe000000, value: 0x14000000, op: LU12I_W, args: instArgs{arg_rd, arg_si20_24_5}},
	// LU32I.D rd, si20
	{mask: 0xfe000000, value: 0x16000000, op: LU32I_D, args: instArgs{arg_rd, arg_si20_24_5}},
	// LU52I.D rd, rj, si12
	{mask: 0xffc00000, value: 0x03000000, op: LU52I_D, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// MASKEQZ rd, rj, rk
	{mask: 0xffff8000, value: 0x00130000, op: MASKEQZ, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MASKNEZ rd, rj, rk
	{mask: 0xffff8000, value: 0x00138000, op: MASKNEZ, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MOD.D rd, rj, rk
	{mask: 0xffff8000, value: 0x00228000, op: MOD_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MOD.DU rd, rj, rk
	{mask: 0xffff8000, value: 0x00238000, op: MOD_DU, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MOD.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00208000, op: MOD_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MOD.WU rd, rj, rk
	{mask: 0xffff8000, value: 0x00218000, op: MOD_WU, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MOVCF2FR fd, cj
	{mask: 0xffffff00, value: 0x0114d400, op: MOVCF2FR, args: instArgs{arg_fd, arg_cj}},
	// MOVCF2GR rd, cj
	{mask: 0xffffff00, value: 0x0114dc00, op: MOVCF2GR, args: instArgs{arg_rd, arg_cj}},
	// MOVFCSR2GR rd, fcsr
	{mask: 0xfffffc00, value: 0x0114c800, op: MOVFCSR2GR, args: instArgs{arg_rd, arg_fcsr_9_5}},
	// MOVFR2CF cd, fj
	{mask: 0xfffffc18, value: 0x0114d000, op: MOVFR2CF, args: instArgs{arg_cd, arg_fj}},
	// MOVFR2GR.D rd, fj
	{mask: 0xfffffc00, value: 0x0114b800, op: MOVFR2GR_D, args: instArgs{arg_rd, arg_fj}},
	// MOVFR2GR.S rd, fj
	{mask: 0xfffffc00, value: 0x0114b400, op: MOVFR2GR_S, args: instArgs{arg_rd, arg_fj}},
	// MOVFRH2GR.S rd, fj
	{mask: 0xfffffc00, value: 0x0114bc00, op: MOVFRH2GR_S, args: instArgs{arg_rd, arg_fj}},
	// MOVGR2CF cd, rj
	{mask: 0xfffffc18, value: 0x0114d800, op: MOVGR2CF, args: instArgs{arg_cd, arg_rj}},
	// MOVGR2FCSR fcsr, rj
	{mask: 0xfffffc00, value: 0x0114c000, op: MOVGR2FCSR, args: instArgs{arg_fcsr_4_0, arg_rj}},
	// MOVGR2FRH.W fd, rj
	{mask: 0xfffffc00, value: 0x0114ac00, op: MOVGR2FRH_W, args: instArgs{arg_fd, arg_rj}},
	// MOVGR2FR.D fd, rj
	{mask: 0xfffffc00, value: 0x0114a800, op: MOVGR2FR_D, args: instArgs{arg_fd, arg_rj}},
	// MOVGR2FR.W fd, rj
	{mask: 0xfffffc00, value: 0x0114a400, op: MOVGR2FR_W, args: instArgs{arg_fd, arg_rj}},
	// MULH.D rd, rj, rk
	{mask: 0xffff8000, value: 0x001e0000, op: MULH_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MULH.DU rd, rj, rk
	{mask: 0xffff8000, value: 0x001e8000, op: MULH_DU, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MULH.W rd, rj, rk
	{mask: 0xffff8000, value: 0x001c8000, op: MULH_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MULH.WU rd, rj, rk
	{mask: 0xffff8000, value: 0x001d0000, op: MULH_WU, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MULW.D.W rd, rj, rk
	{mask: 0xffff8000, value: 0x001f0000, op: MULW_D_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MULW.D.WU rd, rj, rk
	{mask: 0xffff8000, value: 0x001f8000, op: MULW_D_WU, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MUL.D rd, rj, rk
	{mask: 0xffff8000, value: 0x001d8000, op: MUL_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// MUL.W rd, rj, rk
	{mask: 0xffff8000, value: 0x001c0000, op: MUL_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// NOR rd, rj, rk
	{mask: 0xffff8000, value: 0x00140000, op: NOR, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// OR rd, rj, rk
	{mask: 0xffff8000, value: 0x00150000, op: OR, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// ORI rd, rj, ui12
	{mask: 0xffc00000, value: 0x03800000, op: ORI, args: instArgs{arg_rd, arg_rj, arg_ui12_21_10}},
	// ORN rd, rj, rk
	{mask: 0xffff8000, value: 0x00160000, op: ORN, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// PCADDI rd, si20
	{mask: 0xfe000000, value: 0x18000000, op: PCADDI, args: instArgs{arg_rd, arg_si20_24_5}},
	// PCADDU12I rd, si20
	{mask: 0xfe000000, value: 0x1c000000, op: PCADDU12I, args: instArgs{arg_rd, arg_si20_24_5}},
	// PCADDU18I rd, si20
	{mask: 0xfe000000, value: 0x1e000000, op: PCADDU18I, args: instArgs{arg_rd, arg_si20_24_5}},
	// PCALAU12I rd, si20
	{mask: 0xfe000000, value: 0x1a000000, op: PCALAU12I, args: instArgs{arg_rd, arg_si20_24_5}},
	// PRELD hint, rj, si12
	{mask: 0xffc00000, value: 0x2ac00000, op: PRELD, args: instArgs{arg_hint_4_0, arg_rj, arg_si12_21_10}},
	// PRELDX hint, rj, rk
	{mask: 0xffff8000, value: 0x382c0000, op: PRELDX, args: instArgs{arg_hint_4_0, arg_rj, arg_rk}},
	// RDTIMEH.W rd, rj
	{mask: 0xfffffc00, value: 0x00006400, op: RDTIMEH_W, args: instArgs{arg_rd, arg_rj}},
	// RDTIMEL.W rd, rj
	{mask: 0xfffffc00, value: 0x00006000, op: RDTIMEL_W, args: instArgs{arg_rd, arg_rj}},
	// RDTIME.D rd, rj
	{mask: 0xfffffc00, value: 0x00006800, op: RDTIME_D, args: instArgs{arg_rd, arg_rj}},
	// REVB.2H rd, rj
	{mask: 0xfffffc00, value: 0x00003000, op: REVB_2H, args: instArgs{arg_rd, arg_rj}},
	// REVB.2W rd, rj
	{mask: 0xfffffc00, value: 0x00003800, op: REVB_2W, args: instArgs{arg_rd, arg_rj}},
	// REVB.4H rd, rj
	{mask: 0xfffffc00, value: 0x00003400, op: REVB_4H, args: instArgs{arg_rd, arg_rj}},
	// REVB.D rd, rj
	{mask: 0xfffffc00, value: 0x00003c00, op: REVB_D, args: instArgs{arg_rd, arg_rj}},
	// REVH.2W rd, rj
	{mask: 0xfffffc00, value: 0x00004000, op: REVH_2W, args: instArgs{arg_rd, arg_rj}},
	// REVH.D rd, rj
	{mask: 0xfffffc00, value: 0x00004400, op: REVH_D, args: instArgs{arg_rd, arg_rj}},
	// ROTRI.D rd, rj, ui6
	{mask: 0xffff0000, value: 0x004d0000, op: ROTRI_D, args: instArgs{arg_rd, arg_rj, arg_ui6_15_10}},
	// ROTRI.W rd, rj, ui5
	{mask: 0xffff8000, value: 0x004c8000, op: ROTRI_W, args: instArgs{arg_rd, arg_rj, arg_ui5_14_10}},
	// ROTR.D rd, rj, rk
	{mask: 0xffff8000, value: 0x001b8000, op: ROTR_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// ROTR.W rd, rj, rk
	{mask: 0xffff8000, value: 0x001b0000, op: ROTR_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// SCREL.D rd, rj
	{mask: 0xfffffc00, value: 0x38578c00, op: SCREL_D, args: instArgs{arg_rd, arg_rj}},
	// SCREL.W rd, rj
	{mask: 0xfffffc00, value: 0x38578400, op: SCREL_W, args: instArgs{arg_rd, arg_rj}},
	// SC.D rd, rj, si14
	{mask: 0xff000000, value: 0x23000000, op: SC_D, args: instArgs{arg_rd, arg_rj, arg_si14_23_10}},
	// SC.Q rd, rk, rj
	{mask: 0xffff8000, value: 0x38570000, op: SC_Q, args: instArgs{arg_rd, arg_rk, arg_rj}},
	// SC.W rd, rj, si14
	{mask: 0xff000000, value: 0x21000000, op: SC_W, args: instArgs{arg_rd, arg_rj, arg_si14_23_10}},
	// SLLI.D rd, rj, ui6
	{mask: 0xffff0000, value: 0x00410000, op: SLLI_D, args: instArgs{arg_rd, arg_rj, arg_ui6_15_10}},
	// SLLI.W rd, rj, ui5
	{mask: 0xffff8000, value: 0x00408000, op: SLLI_W, args: instArgs{arg_rd, arg_rj, arg_ui5_14_10}},
	// SLL.D rd, rj, rk
	{mask: 0xffff8000, value: 0x00188000, op: SLL_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// SLL.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00170000, op: SLL_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// SLT rd, rj, rk
	{mask: 0xffff8000, value: 0x00120000, op: SLT, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// SLTI rd, rj, si12
	{mask: 0xffc00000, value: 0x02000000, op: SLTI, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// SLTU rd, rj, rk
	{mask: 0xffff8000, value: 0x00128000, op: SLTU, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// SLTUI rd, rj, si12
	{mask: 0xffc00000, value: 0x02400000, op: SLTUI, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// SRAI.D rd, rj, ui6
	{mask: 0xffff0000, value: 0x00490000, op: SRAI_D, args: instArgs{arg_rd, arg_rj, arg_ui6_15_10}},
	// SRAI.W rd, rj, ui5
	{mask: 0xffff8000, value: 0x00488000, op: SRAI_W, args: instArgs{arg_rd, arg_rj, arg_ui5_14_10}},
	// SRA.D rd, rj, rk
	{mask: 0xffff8000, value: 0x00198000, op: SRA_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// SRA.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00180000, op: SRA_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// SRLI.D rd, rj, ui6
	{mask: 0xffff0000, value: 0x00450000, op: SRLI_D, args: instArgs{arg_rd, arg_rj, arg_ui6_15_10}},
	// SRLI.W rd, rj, ui5
	{mask: 0xffff8000, value: 0x00448000, op: SRLI_W, args: instArgs{arg_rd, arg_rj, arg_ui5_14_10}},
	// SRL.D rd, rj, rk
	{mask: 0xffff8000, value: 0x00190000, op: SRL_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// SRL.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00178000, op: SRL_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// STGT.B rd, rj, rk
	{mask: 0xffff8000, value: 0x387c0000, op: STGT_B, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// STGT.D rd, rj, rk
	{mask: 0xffff8000, value: 0x387d8000, op: STGT_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// STGT.H rd, rj, rk
	{mask: 0xffff8000, value: 0x387c8000, op: STGT_H, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// STGT.W rd, rj, rk
	{mask: 0xffff8000, value: 0x387d0000, op: STGT_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// STLE.B rd, rj, rk
	{mask: 0xffff8000, value: 0x387e0000, op: STLE_B, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// STLE.D rd, rj, rk
	{mask: 0xffff8000, value: 0x387f8000, op: STLE_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// STLE.H rd, rj, rk
	{mask: 0xffff8000, value: 0x387e8000, op: STLE_H, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// STLE.W rd, rj, rk
	{mask: 0xffff8000, value: 0x387f0000, op: STLE_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// STPTR.D rd, rj, si14
	{mask: 0xff000000, value: 0x27000000, op: STPTR_D, args: instArgs{arg_rd, arg_rj, arg_si14_23_10}},
	// STPTR.W rd, rj, si14
	{mask: 0xff000000, value: 0x25000000, op: STPTR_W, args: instArgs{arg_rd, arg_rj, arg_si14_23_10}},
	// STX.B rd, rj, rk
	{mask: 0xffff8000, value: 0x38100000, op: STX_B, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// STX.D rd, rj, rk
	{mask: 0xffff8000, value: 0x381c0000, op: STX_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// STX.H rd, rj, rk
	{mask: 0xffff8000, value: 0x38140000, op: STX_H, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// STX.W rd, rj, rk
	{mask: 0xffff8000, value: 0x38180000, op: STX_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// ST.B rd, rj, si12
	{mask: 0xffc00000, value: 0x29000000, op: ST_B, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// ST.D rd, rj, si12
	{mask: 0xffc00000, value: 0x29c00000, op: ST_D, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// ST.H rd, rj, si12
	{mask: 0xffc00000, value: 0x29400000, op: ST_H, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// ST.W rd, rj, si12
	{mask: 0xffc00000, value: 0x29800000, op: ST_W, args: instArgs{arg_rd, arg_rj, arg_si12_21_10}},
	// SUB.D rd, rj, rk
	{mask: 0xffff8000, value: 0x00118000, op: SUB_D, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// SUB.W rd, rj, rk
	{mask: 0xffff8000, value: 0x00110000, op: SUB_W, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// SYSCALL code
	{mask: 0xffff8000, value: 0x002b0000, op: SYSCALL, args: instArgs{arg_code_14_0}},
	// TLBCLR
	{mask: 0xffffffff, value: 0x06482000, op: TLBCLR, args: instArgs{}},
	// TLBFILL
	{mask: 0xffffffff, value: 0x06483400, op: TLBFILL, args: instArgs{}},
	// TLBFLUSH
	{mask: 0xffffffff, value: 0x06482400, op: TLBFLUSH, args: instArgs{}},
	// TLBRD
	{mask: 0xffffffff, value: 0x06482c00, op: TLBRD, args: instArgs{}},
	// TLBSRCH
	{mask: 0xffffffff, value: 0x06482800, op: TLBSRCH, args: instArgs{}},
	// TLBWR
	{mask: 0xffffffff, value: 0x06483000, op: TLBWR, args: instArgs{}},
	// XOR rd, rj, rk
	{mask: 0xffff8000, value: 0x00158000, op: XOR, args: instArgs{arg_rd, arg_rj, arg_rk}},
	// XORI rd, rj, ui12
	{mask: 0xffc00000, value: 0x03c00000, op: XORI, args: instArgs{arg_rd, arg_rj, arg_ui12_21_10}},
}
