/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.TraceInstruction;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public final class XSLTemplate
extends StyleElement
implements StylesheetProcedure {
    private String matchAtt = null;
    private String modeAtt = null;
    private String nameAtt = null;
    private String priorityAtt = null;
    private String asAtt = null;
    private StructuredQName[] modeNames;
    private String diagnosticId;
    private Pattern match;
    private boolean prioritySpecified;
    private double priority;
    private SlotManager stackFrameMap;
    private Template compiledTemplate = new Template();
    private SequenceType requiredType = null;
    private boolean hasRequiredParams = false;

    public boolean isDeclaration() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean mayContainParam(String attName) {
        return true;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLParam;
    }

    public StructuredQName getTemplateName() {
        try {
            String nameAtt;
            if (this.getObjectName() == null && (nameAtt = this.getAttributeValue("", "name")) != null) {
                this.setObjectName(this.makeQName(nameAtt));
            }
            return this.getObjectName();
        }
        catch (NamespaceException err) {
            return null;
        }
        catch (XPathException err) {
            return null;
        }
    }

    protected ItemType getReturnedItemType() {
        if (this.requiredType == null) {
            return this.getCommonChildItemType();
        }
        return this.requiredType.getPrimaryType();
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("mode")) {
                this.modeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("name")) {
                this.nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("match")) {
                this.matchAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("priority")) {
                this.priorityAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("as")) {
                this.asAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        try {
            if (this.modeAtt == null) {
                StructuredQName defaultMode = this.getContainingStylesheet().getDefaultMode();
                if (defaultMode == null) {
                    defaultMode = Mode.UNNAMED_MODE_NAME;
                }
                this.modeNames = new StructuredQName[1];
                this.modeNames[0] = defaultMode;
            } else {
                if (this.matchAtt == null) {
                    this.compileError("The mode attribute must be absent if the match attribute is absent", "XTSE0500");
                }
                int count = 0;
                boolean allModes = false;
                StringTokenizer st = new StringTokenizer(this.modeAtt, " \t\n\r", false);
                while (st.hasMoreTokens()) {
                    st.nextToken();
                    ++count;
                }
                if (count == 0) {
                    this.compileError("The mode attribute must not be empty", "XTSE0550");
                }
                this.modeNames = new StructuredQName[count];
                count = 0;
                st = new StringTokenizer(this.modeAtt, " \t\n\r", false);
                while (st.hasMoreTokens()) {
                    StructuredQName mname;
                    String s = st.nextToken();
                    if ("#default".equals(s)) {
                        mname = this.getContainingStylesheet().getDefaultMode();
                        if (mname == null) {
                            mname = Mode.UNNAMED_MODE_NAME;
                        }
                    } else if ("#unnamed".equals(s) && this.isXslt30Processor()) {
                        mname = Mode.UNNAMED_MODE_NAME;
                    } else if ("#all".equals(s)) {
                        allModes = true;
                        mname = Mode.ALL_MODES;
                    } else {
                        mname = this.makeQName(s);
                    }
                    for (int e = 0; e < count; ++e) {
                        if (!this.modeNames[e].equals(mname)) continue;
                        this.compileError("In the list of modes, the value " + s + " is duplicated", "XTSE0550");
                    }
                    this.modeNames[count++] = mname;
                }
                if (allModes && count > 1) {
                    this.compileError("mode='#all' cannot be combined with other modes", "XTSE0550");
                }
            }
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("XTSE0280");
            if (err.getErrorCodeLocalPart().equals("XTSE0020")) {
                err.setErrorCode("XTSE0550");
            }
            err.setIsStaticError(true);
            this.compileError(err);
        }
        try {
            if (this.nameAtt != null) {
                StructuredQName qName = this.makeQName(this.nameAtt);
                this.setObjectName(qName);
                this.diagnosticId = this.nameAtt;
            }
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("XTSE0280");
            err.setIsStaticError(true);
            this.compileError(err);
        }
        boolean bl = this.prioritySpecified = this.priorityAtt != null;
        if (this.prioritySpecified) {
            if (this.matchAtt == null) {
                this.compileError("The priority attribute must be absent if the match attribute is absent", "XTSE0500");
            }
            try {
                if (!DecimalValue.castableAsDecimal(this.priorityAtt)) {
                    this.compileError("Invalid numeric value for priority (" + this.priority + ')', "XTSE0530");
                }
                this.priority = Double.parseDouble(this.priorityAtt);
            }
            catch (NumberFormatException err) {
                this.compileError("Invalid numeric value for priority (" + this.priority + ')', "XTSE0530");
            }
        }
        if (this.matchAtt != null) {
            this.match = this.makePattern(this.matchAtt);
            if (this.diagnosticId == null) {
                this.diagnosticId = "match=\"" + this.matchAtt + '\"';
                if (this.modeAtt != null) {
                    this.diagnosticId = this.diagnosticId + " mode=\"" + this.modeAtt + '\"';
                }
            }
        }
        if (this.match == null && this.nameAtt == null) {
            this.compileError("xsl:template must have a name or match attribute (or both)", "XTSE0500");
        }
        if (this.asAtt != null) {
            this.requiredType = this.makeSequenceType(this.asAtt);
        }
    }

    public void validate(Declaration decl) throws XPathException {
        NodeInfo param;
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        if (this.match != null) {
            this.match = this.typeCheck("match", this.match);
            if (this.match.getNodeTest() instanceof EmptySequenceTest) {
                try {
                    this.getConfiguration().getErrorListener().warning(new TransformerException("Match pattern cannot match any nodes", this));
                }
                catch (TransformerException e) {
                    this.compileError(XPathException.makeXPathException(e));
                }
            }
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((param = (NodeInfo)kids.next()) != null) {
            if (!(param instanceof XSLParam) || !((XSLParam)param).isRequiredParam()) continue;
            this.hasRequiredParams = true;
            break;
        }
    }

    public void postValidate() throws XPathException {
        this.markTailCalls();
    }

    protected void index(Declaration decl, PrincipalStylesheetModule top) throws XPathException {
        top.indexNamedTemplate(decl);
    }

    public boolean markTailCalls() {
        StyleElement last = this.getLastChildInstruction();
        return last != null && last.markTailCalls();
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        Expression block = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
        if (block == null) {
            block = Literal.makeEmptySequence();
        }
        this.compiledTemplate.setMatchPattern(this.match);
        this.compiledTemplate.setBody(block);
        this.compiledTemplate.setStackFrameMap(this.stackFrameMap);
        this.compiledTemplate.setExecutable(this.getExecutable());
        this.compiledTemplate.setSystemId(this.getSystemId());
        this.compiledTemplate.setLineNumber(this.getLineNumber());
        this.compiledTemplate.setHasRequiredParams(this.hasRequiredParams);
        this.compiledTemplate.setRequiredType(this.requiredType);
        Expression exp = null;
        try {
            exp = this.makeExpressionVisitor().simplify(block);
        }
        catch (XPathException e) {
            this.compileError(e);
        }
        try {
            if (this.requiredType != null) {
                RoleLocator role = new RoleLocator(7, (Serializable)((Object)this.diagnosticId), 0);
                role.setErrorCode("XTTE0505");
                exp = TypeChecker.staticTypeCheck(exp, this.requiredType, false, role, this.makeExpressionVisitor());
            }
        }
        catch (XPathException err) {
            this.compileError(err);
        }
        this.compiledTemplate.setBody(exp);
        this.compiledTemplate.setTemplateName(this.getObjectName());
        if (this.getConfiguration().isCompileWithTracing()) {
            TraceInstruction trace = new TraceInstruction(exp, this);
            trace.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            trace.setContainer(this.compiledTemplate);
            exp = trace;
            this.compiledTemplate.setBody(exp);
        }
        return null;
    }

    public void register(Declaration declaration) throws XPathException {
        if (this.match != null) {
            StylesheetModule module = declaration.getModule();
            int slots = this.match.allocateSlots(this.getStaticContext(), this.getSlotManager(), 0);
            RuleManager mgr = this.getPreparedStylesheet().getRuleManager();
            for (int i = 0; i < this.modeNames.length; ++i) {
                StructuredQName nc = this.modeNames[i];
                Mode mode = mgr.getMode(nc, true);
                if (this.prioritySpecified) {
                    mgr.setTemplateRule(this.match, this.compiledTemplate, mode, module, this.priority);
                } else {
                    mgr.setTemplateRule(this.match, this.compiledTemplate, mode, module, Double.NaN);
                }
                mode.allocatePatternSlots(slots);
                if (!mode.isStreamable()) continue;
                this.compiledTemplate.setStreamable(true);
            }
            this.allocatePatternSlots(slots);
        }
    }

    public void optimize(Declaration declaration) throws XPathException {
        Expression exp2;
        ItemType contextItemType = Type.ITEM_TYPE;
        if (this.getObjectName() == null) {
            contextItemType = this.match.getNodeTest();
        }
        Expression exp = this.compiledTemplate.getBody();
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        visitor.setOptimizeForStreaming(this.compiledTemplate.isStreamable());
        Optimizer opt = this.getConfiguration().getOptimizer();
        try {
            exp2 = visitor.typeCheck(exp, contextItemType);
            if (opt.getOptimizationLevel() != 0) {
                exp2 = visitor.optimize(exp2, contextItemType);
            }
            if (exp != exp2) {
                this.compiledTemplate.setBody(exp2);
                exp = exp2;
            }
        }
        catch (XPathException e) {
            this.compileError(e);
        }
        if (opt.getOptimizationLevel() != 0 && !this.getConfiguration().isCompileWithTracing() && (exp2 = opt.promoteExpressionsToGlobal(exp, visitor)) != null) {
            this.compiledTemplate.setBody(visitor.optimize(exp2, contextItemType));
            exp = exp2;
        }
        this.allocateSlots(exp);
        if (this.isExplaining()) {
            PrintStream err = this.getConfiguration().getStandardErrorOutput();
            err.println("Optimized expression tree for template at line " + this.getLineNumber() + " in " + this.getSystemId() + ':');
            exp.explain(err);
        }
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public Template getCompiledTemplate() {
        return this.compiledTemplate;
    }

    public int getConstructType() {
        return 200;
    }
}

