/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.MergeDocIDRemapper;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;

class BufferedDeletes {
    int numTerms;
    HashMap<Term, Num> terms = new HashMap();
    HashMap<Query, Integer> queries = new HashMap();
    List<Integer> docIDs = new ArrayList<Integer>();
    long bytesUsed;

    BufferedDeletes() {
    }

    int size() {
        return this.numTerms + this.queries.size() + this.docIDs.size();
    }

    void update(BufferedDeletes in) {
        this.numTerms += in.numTerms;
        this.bytesUsed += in.bytesUsed;
        this.terms.putAll(in.terms);
        this.queries.putAll(in.queries);
        this.docIDs.addAll(in.docIDs);
        in.clear();
    }

    void clear() {
        this.terms.clear();
        this.queries.clear();
        this.docIDs.clear();
        this.numTerms = 0;
        this.bytesUsed = 0L;
    }

    void addBytesUsed(long b) {
        this.bytesUsed += b;
    }

    boolean any() {
        return this.terms.size() > 0 || this.docIDs.size() > 0 || this.queries.size() > 0;
    }

    synchronized void remap(MergeDocIDRemapper mapper, SegmentInfos infos, int[][] docMaps, int[] delCounts, MergePolicy.OneMerge merge, int mergeDocCount) {
        HashMap<Query, Integer> newDeleteQueries;
        ArrayList<Integer> newDeleteDocIDs;
        HashMap<Term, Num> newDeleteTerms;
        if (this.terms.size() > 0) {
            newDeleteTerms = new HashMap<Term, Num>();
            for (Map.Entry<Term, Num> entry : this.terms.entrySet()) {
                Num num = entry.getValue();
                newDeleteTerms.put(entry.getKey(), new Num(mapper.remap(num.getNum())));
            }
        } else {
            newDeleteTerms = null;
        }
        if (this.docIDs.size() > 0) {
            newDeleteDocIDs = new ArrayList<Integer>(this.docIDs.size());
            for (Integer n : this.docIDs) {
                newDeleteDocIDs.add(mapper.remap(n));
            }
        } else {
            newDeleteDocIDs = null;
        }
        if (this.queries.size() > 0) {
            newDeleteQueries = new HashMap<Query, Integer>(this.queries.size());
            for (Map.Entry<Query, Integer> entry : this.queries.entrySet()) {
                Integer num = entry.getValue();
                newDeleteQueries.put(entry.getKey(), mapper.remap(num));
            }
        } else {
            newDeleteQueries = null;
        }
        if (newDeleteTerms != null) {
            this.terms = newDeleteTerms;
        }
        if (newDeleteDocIDs != null) {
            this.docIDs = newDeleteDocIDs;
        }
        if (newDeleteQueries != null) {
            this.queries = newDeleteQueries;
        }
    }

    static final class Num {
        private int num;

        Num(int num) {
            this.num = num;
        }

        int getNum() {
            return this.num;
        }

        void setNum(int num) {
            if (num > this.num) {
                this.num = num;
            }
        }
    }
}

